<?php
set_time_limit(0);
$results = [];
$path = $_POST['path'] ?? '';
$keyword = $_POST['keyword'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($keyword) && !empty($path) && is_dir($path)) {
        $dir = new RecursiveDirectoryIterator($path, FilesystemIterator::SKIP_DOTS);
        $it  = new RecursiveIteratorIterator($dir);

        foreach ($it as $file) {
            if ($file->isFile()) {
                $content = @file_get_contents($file->getPathname());
                if ($content !== false && stripos($content, $keyword) !== false) {
                    $results[] = $file->getPathname();
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Search Files</title>
</head>
<body>
  <h2>Search Files</h2>
  <form method="POST">
    <label>Path: <input type="text" name="path" value="<?php echo htmlspecialchars($path); ?>" size="50"></label><br><br>
    <label>Keyword: <input type="text" name="keyword" value="<?php echo htmlspecialchars($keyword); ?>"></label><br><br>
    <button type="submit">Search</button>
  </form>

  <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
    <h2>Search Result: "<?php echo htmlspecialchars($keyword); ?>"</h2>
    <?php if ($results): ?>
      <ul>
        <?php foreach ($results as $r): ?>
          <li><?php echo htmlspecialchars($r); ?></li>
        <?php endforeach; ?>
      </ul>
    <?php else: ?>
      <p>No files found.</p>
    <?php endif; ?>
  <?php endif; ?>
</body>
</html>
